VERSION 5.00
Begin VB.Form MultiPoint 
   Appearance      =   0  'Flat
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "DAC-02 Multiple Point Output"
   ClientHeight    =   3810
   ClientLeft      =   1125
   ClientTop       =   1500
   ClientWidth     =   6855
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   8.25
      Charset         =   0
      Weight          =   700
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   ForeColor       =   &H80000008&
   Icon            =   "MULTIPOI.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   PaletteMode     =   1  'UseZOrder
   ScaleHeight     =   3810
   ScaleWidth      =   6855
   Begin VB.Frame Frame6 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Display"
      ForeColor       =   &H80000008&
      Height          =   975
      Left            =   2880
      TabIndex        =   17
      Top             =   2640
      Width           =   2295
      Begin VB.TextBox Display 
         Appearance      =   0  'Flat
         BackColor       =   &H00FFFFFF&
         ForeColor       =   &H00FF0000&
         Height          =   285
         Left            =   360
         MaxLength       =   8
         TabIndex        =   18
         TabStop         =   0   'False
         Text            =   "0"
         Top             =   480
         Width           =   975
      End
      Begin VB.Label Label5 
         Appearance      =   0  'Flat
         BackColor       =   &H00C0C0C0&
         Caption         =   "Volts"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   1560
         TabIndex        =   19
         Top             =   480
         Width           =   495
      End
   End
   Begin VB.Frame Frame5 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Delay"
      ForeColor       =   &H80000008&
      Height          =   975
      Left            =   2880
      TabIndex        =   14
      Top             =   1440
      Width           =   2295
      Begin VB.TextBox ConvDelay 
         Appearance      =   0  'Flat
         Height          =   285
         Left            =   360
         MaxLength       =   5
         TabIndex        =   15
         Text            =   "1"
         Top             =   480
         Width           =   975
      End
      Begin VB.Label Label4 
         Appearance      =   0  'Flat
         BackColor       =   &H00C0C0C0&
         Caption         =   "Sec."
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   1560
         TabIndex        =   16
         Top             =   480
         Width           =   495
      End
   End
   Begin VB.Frame Frame4 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Channel"
      ForeColor       =   &H80000008&
      Height          =   975
      Left            =   2880
      TabIndex        =   12
      Top             =   240
      Width           =   2295
      Begin VB.TextBox mchan 
         Appearance      =   0  'Flat
         Height          =   285
         Left            =   960
         MaxLength       =   1
         TabIndex        =   13
         Text            =   "0"
         Top             =   480
         Width           =   255
      End
   End
   Begin VB.Frame Frame3 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Step Volts"
      ForeColor       =   &H80000008&
      Height          =   975
      Left            =   240
      TabIndex        =   5
      Top             =   2640
      Width           =   2295
      Begin VB.TextBox StepOut 
         Appearance      =   0  'Flat
         Height          =   285
         Left            =   240
         MaxLength       =   6
         TabIndex        =   10
         Text            =   "1.00"
         Top             =   480
         Width           =   975
      End
      Begin VB.Label Label3 
         Appearance      =   0  'Flat
         BackColor       =   &H00C0C0C0&
         Caption         =   "Volts"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   1440
         TabIndex        =   11
         Top             =   480
         Width           =   495
      End
   End
   Begin VB.Frame Frame2 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Stop Volts"
      ForeColor       =   &H80000008&
      Height          =   975
      Left            =   240
      TabIndex        =   4
      Top             =   1440
      Width           =   2295
      Begin VB.TextBox StopOut 
         Appearance      =   0  'Flat
         Height          =   285
         Left            =   240
         MaxLength       =   6
         TabIndex        =   8
         Text            =   "10.00"
         Top             =   480
         Width           =   975
      End
      Begin VB.Label Label2 
         Appearance      =   0  'Flat
         BackColor       =   &H00C0C0C0&
         Caption         =   "Volts"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   1440
         TabIndex        =   9
         Top             =   480
         Width           =   495
      End
   End
   Begin VB.Frame Frame1 
      Appearance      =   0  'Flat
      BackColor       =   &H00C0C0C0&
      Caption         =   "Start Volts"
      ForeColor       =   &H80000008&
      Height          =   975
      Left            =   240
      TabIndex        =   3
      Top             =   240
      Width           =   2295
      Begin VB.TextBox StartOut 
         Appearance      =   0  'Flat
         Height          =   285
         Left            =   240
         MaxLength       =   6
         TabIndex        =   6
         Text            =   "-10.00"
         Top             =   480
         Width           =   975
      End
      Begin VB.Label Label1 
         Appearance      =   0  'Flat
         BackColor       =   &H00C0C0C0&
         Caption         =   "Volts"
         ForeColor       =   &H80000008&
         Height          =   255
         Left            =   1440
         TabIndex        =   7
         Top             =   480
         Width           =   495
      End
   End
   Begin VB.CommandButton StopBtn 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "St&op"
      Height          =   495
      Left            =   5520
      TabIndex        =   2
      Top             =   2160
      Width           =   1095
   End
   Begin VB.Timer Clock 
      Enabled         =   0   'False
      Interval        =   1
      Left            =   5640
      Top             =   480
   End
   Begin VB.CommandButton Start 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "St&art"
      Height          =   495
      Left            =   5520
      TabIndex        =   1
      Top             =   1440
      Width           =   1095
   End
   Begin VB.CommandButton MultiClose 
      Appearance      =   0  'Flat
      BackColor       =   &H80000005&
      Caption         =   "&Close"
      Height          =   495
      Left            =   5520
      TabIndex        =   0
      Top             =   3120
      Width           =   1095
   End
End
Attribute VB_Name = "MultiPoint"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim StartDec As Integer
Dim StopDec As Integer
Dim StepDec As Integer
Dim ClkStart As Integer
Dim ClkStop As Integer
Dim ClkStep As Integer
Dim ClkChan As Integer
Dim clkcount As Integer
Dim clksign As Integer
Dim OutData As Integer
Dim Bipolar As Integer
Dim Gain As Double

Private Sub Clock_Timer()
Dim Conv As Integer
Dim HByte As Integer
Dim LByte As Integer
        
        Conv = False

        DasErr = UpdateOut()

        OutData = StartDec + StepDec * clkcount * clksign

        
        If (OutData >= 0) And (OutData <= 4095) Then
            If clksign < 0 And OutData >= StopDec Then Conv = True
            If clksign > 0 And OutData <= StopDec Then Conv = True
        Else
            StopBtn_Click
        End If

        If Bipolar = True Then OutData = 4095 - OutData
        
        If Conv = True Then
            clkcount = clkcount + 1
            HByte = Int(OutData / 16)
            LByte = 16 * (OutData - HByte * 16)
            'DasErr = dasbyteout(CardBase + 2 * ClkChan, LByte)
            DlPortWritePortUchar CardBase + 2 * ClkChan, LByte
            'DasErr = dasbyteout(CardBase + 2 * ClkChan + 1, HByte)
            DlPortWritePortUchar CardBase + 2 * ClkChan + 1, HByte

            OutData = HByte * 16 + Int(LByte / 16)
'            Text1.Text = Str(OutData)
            If Bipolar = True Then
                Display.Text = Format$((2047 - OutData) / Gain, "#00.000")
            Else
                Display.Text = Format$(OutData / Gain, "#00.000")
            End If
        Else
            StopBtn_Click
        End If

End Sub

Private Sub ConvDelay_Change()
        ' only allow 0 - 9

    If Not (KeyAscii >= &H30 And KeyAscii <= &H39) Then
        KeyAscii = 0
    End If

End Sub

Private Sub Form_Load()
   DasErr = UpdateOut()
   Start.Enabled = True
   Start.Default = True
   StopBtn.Enabled = False

End Sub

Private Sub Form_Unload(Cancel As Integer)
    Call MultiClose_Click
End Sub

Private Sub mchan_KeyPress(KeyAscii As Integer)
        ' only allow 0 - 1

    If Not ((KeyAscii >= &H30 And KeyAscii <= &H31) Or KeyAscii = &H8) Then
        KeyAscii = 0
    End If
End Sub

Private Sub MultiClose_Click()
    MultiPoint.Hide
    Main.Show

End Sub

Private Sub Start_Click()
    DasErr = UpdateOut()        ' Update/adjust data field
    ClkStart = StartDec
    ClkStop = StopDec
    ClkStep = StepDec
    ClkChan = Val(mchan.Text)
    clkcount = 0
    clksign = 1
    If Val(StepOut.Text) < 0 Then clksign = -1
    Clock.Interval = Val(ConvDelay.Text) * 1000
    Clock.Enabled = True
    Start.Enabled = False
    StopBtn.Enabled = True
    StopBtn.Default = True
    MultiClose.Enabled = False
End Sub

Private Sub StartOut_KeyPress(KeyAscii As Integer)

    If Not ((KeyAscii >= &H30 And KeyAscii <= &H39) Or KeyAscii = &H2E Or KeyAscii = &H2D Or KeyAscii = &H8) Then
        KeyAscii = 0
    End If
    
End Sub

Private Sub StartOut_LostFocus()
        DasErr = UpdateOut()
End Sub

Private Sub StepOut_KeyPress(KeyAscii As Integer)

    If Not ((KeyAscii >= &H30 And KeyAscii <= &H39) Or KeyAscii = &H2E Or KeyAscii = &H2D Or KeyAscii = &H8) Then
        KeyAscii = 0
    End If
    
End Sub

Private Sub StepOut_LostFocus()
        DasErr = UpdateOut()


End Sub

Private Sub StopBtn_Click()
    Clock.Enabled = False
    StopBtn.Enabled = False
    Start.Enabled = True
    MultiClose.Enabled = True
    Start.Default = True
End Sub

Private Sub StopOut_KeyPress(KeyAscii As Integer)

    If Not ((KeyAscii >= &H30 And KeyAscii <= &H39) Or KeyAscii = &H2E Or KeyAscii = &H2D Or KeyAscii = &H8) Then
        KeyAscii = 0
    End If
    
End Sub

Private Sub StopOut_LostFocus()
        
        DasErr = UpdateOut()

End Sub

Private Function UpdateOut() As Integer
Dim tstr As String
Dim Offset As Integer
Dim dvolts As Integer
Dim vstep As Single

        
        On (Config.Range(Val(mchan.Text)).ListIndex) + 1 GoTo 6, 7, 8, 9
6           Offset = 0              ' Unipolar
            Gain = 819.2
            Bipolar = False
            GoTo 10
7           Offset = 0
            Gain = 409.6
            Bipolar = False
            GoTo 10
8           Offset = 2048           ' Bipolar
            Gain = 409.6
            Bipolar = True
            GoTo 10
9           Offset = 2048
            Gain = 204.8
            Bipolar = True

      
10      dvolts = Val(StartOut.Text) * Gain + Offset ' Convert to integer
        If dvolts > 4095 Then dvolts = 4095 'max
        If dvolts < 0 Then dvolts = 0 'min
        StartDec = dvolts                           ' Save to global variable
        StartOut.Text = Str((dvolts - Offset) / Gain) ' Update text box
    
        dvolts = Val(StopOut.Text) * Gain + Offset
        If dvolts > 4095 Then dvolts = 4095 'max
        If dvolts < 0 Then dvolts = 0 'min
        StopDec = dvolts
        StopOut.Text = Str((dvolts - Offset) / Gain)
    
        vstep = Val(StepOut.Text)
        ' Adjust the stepping direction
        If vstep > 0 And (StopDec < StartDec) Then vstep = vstep * -1#
        If vstep < 0 And (StopDec > StartDec) Then vstep = vstep * -1#
        
        dvolts = Abs(vstep) * Gain
        StepDec = dvolts
        StepOut.Text = Str(vstep)

End Function

